/*------------------------------------------------------------------------------*
 * File Name: XFWizard_utils.c													*
 * Creation: Sim 03-20-2007														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 01-07-2008 QA80-12833 FIX_APPLY_XF_WIZ_XF_TWICE							*
 *	Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE				*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <xfutils.h>
#include <..\OriginLab\XFWizard_utils.h>
//#include <xfutils.h>
//
//#include <..\OriginLab\XFWiz.h>
//#include <..\OriginLab\XFCore.h>
//#include <..\OriginLab\XFWizScript.h>
//#include <..\OriginLab\XFWizDlg.h>

///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
//#include <..\OriginLab\XFWiz.h>
///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE

///---Sim 11-06-2008 FIX_FORGET_SET_TARGET_PAGE_ALSO
static bool _get_target_page_from_range(Page& pg, const DataRange& dr)
{
	vector<uint> vPlotUID;
	dr.GetPlots(vPlotUID);
	if ( vPlotUID.GetSize() > 0 )
	{
		ASSERT(vPlotUID.GetSize() == 1);
		DataPlot	dp;
		dp = (DataPlot)Project.GetObject(vPlotUID[0]);
		if ( dp )
		{
			Layer ly;
			dp.GetParent(ly);
			if ( ly )
			{
				pg = ly.GetPage();
			}
		}
	}
	
	if ( !pg )
	{
		Datasheet ds;
		int c1, c2;
		if ( dr.GetRange(ds, c1, c2) && ds )
		{
			pg = ds.GetPage();
		}
	}
	
	return ( pg && pg.IsValid() );
}
///---END FIX_FORGET_SET_TARGET_PAGE_ALSO

///Jasmine 11/05/08 THIS_UTIL_FUNC_CAN_USE_IN_OTHER_XFWIZ_LIKE_NANOSIZER
///Sandy 2008-9-9 ADD_UTIL_FUNC_TO_CONSTRUCT_IT_TREE_FOR_AVOID_FILE_AUTO_LOAD_TO_MUCH_IN_PA_OXF
///---Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE
/*
bool        construct_tree_for_input_range_of_xf(TreeNode& trIO, const string strXF,  const DataRange& dr)
{

	if(!trIO ||!dr)
		return false;
	
	XFWizInputOutputRange paRange;
	Array<DataRange&> arrRange;
	arrRange.Add(dr);
	if(!paRange.Add(&arrRange, strXF, true))
		return false;
	///---Sim 11-06-2008 FIX_FORGET_SET_TARGET_PAGE_ALSO
	Page pg;
	if ( _get_target_page_from_range(pg, dr) )
		paRange.SetTargetPage(pg);			
	///---END FIX_FORGET_SET_TARGET_PAGE_ALSO
	if(!paRange.GetTree(trIO))
		return false;
	
	return true;
}
*/
bool xfwiz_construct_input_range(XFWizInputOutputRange *pXFWizIO, LPCSTR lpcszXFName, const DataRange& dr)
{

	if( NULL == pXFWizIO || !dr || !dr.IsValid() )
		return false;
	
	Array<DataRange&> arrRange;
	arrRange.Add(dr);
	if( !pXFWizIO->Add(&arrRange, lpcszXFName, true) ) // input
		return false;
	///---Sim 11-06-2008 FIX_FORGET_SET_TARGET_PAGE_ALSO
	Page pg;
	if ( _get_target_page_from_range(pg, dr) )
		pXFWizIO->SetTargetPage(pg);			
	///---END FIX_FORGET_SET_TARGET_PAGE_ALSO
	
	return true;
}
///---END XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE


///End THIS_UTIL_FUNC_CAN_USE_IN_OTHER_XFWIZ_LIKE_NANOSIZER

/*
#define STR_NODE_DATARANGE	"DataRange"
#define STR_NODE_XF_NAME	"XFName"
#define STR_NODE_VAR		"Var"

/#
	trInputsOutputs
		|--Range1
			|--DataRange
			|--XFName
			|--Var
		|--Range2
			|--...
		|--...
#/
static void _update_input_output_range_from_tree(XFWizInputOutputRange& xfwio, const TreeNode& trInputsOutputs)
{
	xfwio.Reset();
	for ( int ii = 0; ii < trInputsOutputs.GetNodeCount(); ii++)
	{
		TreeNode tr =  trInputsOutputs.Children.Item(ii);
		TreeNode trDataRange = tr.GetNode(STR_NODE_DATARANGE);
		DataRange dr;
		if ( trDataRange && okxf_resolve_string_get_origin_object(trDataRange.strVal, &dr) )
		{
			TreeNode trXFName = tr.GetNode(STR_NODE_XF_NAME);
			TreeNode trVar = tr.GetNode(STR_NODE_VAR);
			if ( trXFName && trVar )
			{
				xfwio.Add(dr, trXFName.strVal, trVar.strVal);
			}			
		}
	}
}
*/
/*
int		run_wiz_nodlg(XFCore* pxfc, Page &pgSource, Tree &trTheme, TreeNode &trInputsOutputs, DWORD dwUIDOp) // = NULL, NULL, 0
{
	//XFWizScript xfwspt(pxfc);
	XFWizScript xfwspt;
	if ( !xfwspt.Run(pgSource, trTheme, trInputsOutputs) )
		return -1;
	return 0;
}

int		open_wiz_dlg(XFCore* pxfc, Page &pgSource, Tree &trTheme, TreeNode &trInputsOutputs, DWORD dwUIDOp) // = NULL, NULL, 0
{
	//XFWizDlg *pXFWizDlg = new XFWizDlg(pxfc);
	XFWizDlg *pXFWizDlg = new XFWizDlg;
	if ( NULL == pXFWizDlg )
		return -1;
	
	if ( pXFWizDlg->Create(GetWindow(), pgSource, trTheme, trInputsOutputs) )
	{
		//Window winDlg = pXFWizDlg->GetWindow();
		//if ( winDlg )
			//winDlg.ShowWindow(SW_NORMAL);
		page_xf_dynadlg_shown_control(pgSource, 1, false); // show dialog and keep status
	}
	
	return 0;
}
*/


/*
// Sandy and Sim call, Marko/Yuri write:
int	wiz_do_operation(Tree &trTheme, TreeNode &trInputsOutputs, DWORD dwUIDOp)
{
	if ( dwUIDOp )
	{
		WizOperation	wizOp = (WizOperation)Project.GetObject(dwUIDOp);
		wizOp.SetThemeInputsOutputs(theme, trInputsOutputs, TRUE);
	}
	else
	{
		bool bInitOk;
		OperationBase& op = op_create("WizOperation", bInitOk);
		if( op && bInitOk )
		{
			WizOperation	&wizOp = (WizOperation&)op;
			wizOp.SetThemeInputsOutputs(theme, trInputsOutputs, FALSE);
		}
	}

	
	return 0;		// OK
}
*/

///---Sim 01-07-2008 QA80-12833 FIX_APPLY_XF_WIZ_XF_TWICE
/*
#define STR_XF_CORE_HANDLER_ATTRIB		"XFCoreHanlder"
void set_xf_core_handler(TreeNode &trGetN, XFCore* pxfc)
{
	int nHandler = (int)pxfc;
	XFCore *pp = (XFCore*)nHandler;
	ASSERT(pp);
	trGetN.SetAttribute(STR_XF_CORE_HANDLER_ATTRIB, nHandler);
}

XFCore*	get_xf_core_handler(const TreeNode &trGetN)
{
	XFCore* pxfc = NULL;
	
	int nHandler;
	if ( trGetN.GetAttribute(STR_XF_CORE_HANDLER_ATTRIB, nHandler) )
	{
		pxfc = (XFCore*)nHandler;
	}
	
	return pxfc;
}
*/
void set_xf_core_handler(TreeNode &trGetN, XFCore* pxfc)
{
	if ( !trGetN )
	{
		ASSERT(FALSE);
		return;
	}
	
	int nPointer = (int)pxfc;
	if ( trGetN.NODE_NAME_XF_WIZ_CORE_POINTER )
		trGetN.NODE_NAME_XF_WIZ_CORE_POINTER.nVal = nPointer;
	else
		trGetN.SetAttribute(STR_ATTRIB_XF_WIZ_CORE_POINTER, nPointer);
		
	XFCore *pp = (XFCore*)nPointer;
	ASSERT(pp);
}

XFCore*	get_xf_core_handler(const TreeNode &trGetN)
{
	if ( !trGetN )
		return NULL;
	
	int nPointer = 0;	
	if ( trGetN.NODE_NAME_XF_WIZ_CORE_POINTER )
		nPointer = trGetN.NODE_NAME_XF_WIZ_CORE_POINTER.nVal;
	else
		trGetN.GetAttribute(STR_ATTRIB_XF_WIZ_CORE_POINTER, nPointer);
	
	XFCore* pxfc = (XFCore*)nPointer;
	
	ASSERT(pxfc);
	return pxfc;
}
XFCore*	get_xf_core_handler(int nPointer)
{
	XFCore* pxfc = (XFCore*)nPointer;
	ASSERT(pxfc);
	return pxfc;
}
///---END QA80-12833 FIX_APPLY_XF_WIZ_XF_TWICE

XFCore*	get_current_xf_core_handler()
{
	XFExeContext	*pxfexectxt = Project.GetCurrentXFExeCtxt();
	if ( !pxfexectxt )
		return NULL;
	
	Tree trRoot;
	TreeNode trGetN;
	pxfexectxt->GetGUI(trRoot, trGetN, XFGETN_EX_NONE, XFGETN_EX_NONE);
		
	return get_xf_core_handler(trGetN);
}
